function [ dt ] = Mesh_S( xinc, yinc )
%Mesh a standard square with given increments in x-y
%   On the unit square generate a uniform mesh. Output is via a deluanay
%   triangulation function.

%Number of nodes on each axis.
nx = floor(1/xinc);
ny = floor(1/yinc);

xaxis = 0:1/nx:1;
yaxis = 0:1/ny:1;

%Grid on standard square.  So
%it's ordered by cycling across and up. At (j-1)*nr+nr have boundary node
%for j=1:nt
for j=1:ny+1
    for i=1:nx+1
    xnodes((j-1)*(nx+1)+i,1) = xaxis(1,i);
    ynodes((j-1)*(nx+1)+i,1) = yaxis(1,j);
    end
end


dt = DelaunayTri(xnodes,ynodes);

end

